<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
$DATA = __DIR__ . '/data/tips.json';
$PASS = getenv('GTIPS_PASS') ?: 'salam@2025';
if (!isset($_SESSION['logged_in'])) $_SESSION['logged_in'] = false;
if (isset($_POST['action']) && $_POST['action']==='login') {
  $p = $_POST['password'] ?? '';
  if (hash('sha256',$p) === hash('sha256',$PASS)) { $_SESSION['logged_in']=true; $_SESSION['csrf']=bin2hex(random_bytes(16)); header('Location: admin.php'); exit; }
  else $err='رمز اشتباه است.';
}
if (isset($_GET['logout'])) { session_destroy(); header('Location: admin.php'); exit; }
if (!$_SESSION['logged_in']) { ?>
<!doctype html><html lang="fa" dir="rtl"><meta charset="utf-8"><title>ورود — مدیریت نکات</title><style>
body{font-family:'IRANYekanX','IRANSansWeb',system-ui;margin:0;background:#0b1020;color:#f8fafc;display:flex;align-items:center;justify-content:center;height:100vh}
.card{background:rgba(255,255,255,.08);backdrop-filter:blur(14px);padding:24px;border-radius:14px;width:320px;border:1px solid rgba(255,255,255,.16)}
h1{margin:0 0 12px;font-size:18px}
input[type=password],button{width:100%;padding:10px;border-radius:10px;border:1px solid rgba(255,255,255,.2);background:rgba(255,255,255,.06);color:#fff}
button{margin-top:10px;cursor:pointer}.err{color:#fca5a5;margin:8px 0}
</style><body><div class="card"><h1>ورود به مدیریت نکات</h1><?php if(isset($err)) echo '<div class="err">'.$err.'</div>'; ?>
<form method="post"><input type="hidden" name="action" value="login"><label>رمز عبور</label><input type="password" name="password" placeholder="••••••••" required><button type="submit">ورود</button></form></div></body></html>
<?php exit; }
$tips = is_readable($DATA)? json_decode(file_get_contents($DATA), true):[];
usort($tips,function($a,$b){return ($a['sort_order']??$a['id']) <=> ($b['sort_order']??$b['id']);});
?><!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>مدیریت ۴۰ نکته — سلام‌بابا</title><style>
@font-face{font-family:'IRANYekanX';src:url('https://salambaba.co/font/IRANYekanXRegular.woff2') format('woff2');font-weight:400;font-display:swap}
@font-face{font-family:'IRANYekanX';src:url('https://salambaba.co/font/IRANYekanXBold.woff2') format('woff2');font-weight:700;font-display:swap}
body{margin:0;font-family:'IRANYekanX',system-ui;direction:rtl;background:#0b1020;color:#e5e7eb}
.top{display:flex;align-items:center;justify-content:space-between;padding:12px 16px;background:rgba(255,255,255,.06);backdrop-filter:blur(12px)}
a.btn,button.btn{padding:8px 12px;border-radius:10px;border:1px solid rgba(255,255,255,.2);background:rgba(255,255,255,.08);color:#fff;text-decoration:none;cursor:pointer}
.table{width:100%;border-collapse:collapse;margin-top:10px}
.table th,.table td{padding:8px;border-bottom:1px solid rgba(255,255,255,.12);vertical-align:top}
.wrap{max-width:1100px;margin:0 auto;padding:10px}
form .row{display:grid;grid-template-columns:1fr 1fr;gap:10px}
form .row .col{display:flex;flex-direction:column}
input[type=text],input[type=number],textarea,select{padding:10px;border-radius:10px;border:1px solid rgba(255,255,255,.2);background:rgba(255,255,255,.06);color:#fff}
textarea{min-height:100px}
.badge{font-size:.8rem;opacity:.8}
</style></head><body>
<div class="top"><div>مدیریت ۴۰ نکته — <span class="badge">سلام‌بابا</span></div><div><a class="btn" href="index.php" target="_blank">نمایش عمومی</a><a class="btn" href="?logout=1">خروج</a></div></div>
<div class="wrap"><h3>افزودن / ویرایش نکته</h3>
<form method="post" action="save.php">
<input type="hidden" name="csrf" value="<?php echo htmlspecialchars($_SESSION['csrf']); ?>">
<div class="row">
<div class="col"><label>شناسه (id)</label><input type="number" name="id" required></div>
<div class="col"><label>شماره نمایش (sort_order)</label><input type="number" name="sort_order"></div>
<div class="col"><label>عنوان</label><input type="text" name="title" required></div>
<div class="col"><label>برچسب</label><input type="text" name="tag" value="سلام‌بابا"></div>
<div class="col" style="grid-column:1/-1"><label>بولت‌ها (هر خط یک مورد)</label><textarea name="bullets"></textarea></div>
<div class="col" style="grid-column:1/-1"><label>توضیح کوتاه</label><textarea name="desc"></textarea></div>
<div class="col"><label>نمایش</label><select name="visible"><option value="1">بله</option><option value="0">خیر</option></select></div>
</div><button class="btn" type="submit" name="action" value="upsert">ذخیره</button></form>
<h3>لیست نکات</h3>
<table class="table"><thead><tr><th>#</th><th>عنوان</th><th>نمایش</th><th>ترتیب</th><th>ابزار</th></tr></thead><tbody>
<?php foreach($tips as $t): ?><tr><td><?php echo (int)$t['id']; ?></td><td><?php echo htmlspecialchars($t['title']); ?></td><td><?php echo (int)($t['visible']??1) ? '✅' : '⛔'; ?></td><td><?php echo (int)($t['sort_order']??$t['id']); ?></td><td>
<form method="post" action="save.php" style="display:inline"><input type="hidden" name="csrf" value="<?php echo htmlspecialchars($_SESSION['csrf']); ?>"><input type="hidden" name="id" value="<?php echo (int)$t['id']; ?>"><button class="btn" name="action" value="load" formaction="save.php">ویرایش</button></form>
<form method="post" action="save.php" style="display:inline" onsubmit="return confirm('حذف شود؟')"><input type="hidden" name="csrf" value="<?php echo htmlspecialchars($_SESSION['csrf']); ?>"><input type="hidden" name="id" value="<?php echo (int)$t['id']; ?>"><button class="btn" name="action" value="delete">حذف</button></form>
</td></tr><?php endforeach; ?>
</tbody></table>
<?php if(isset($_SESSION['edit_item'])): $e=$_SESSION['edit_item']; unset($_SESSION['edit_item']); ?>
<h3>ویرایش نکته #<?php echo (int)$e['id']; ?></h3>
<form method="post" action="save.php"><input type="hidden" name="csrf" value="<?php echo htmlspecialchars($_SESSION['csrf']); ?>"><input type="hidden" name="id" value="<?php echo (int)$e['id']; ?>">
<div class="row">
<div class="col"><label>عنوان</label><input type="text" name="title" value="<?php echo htmlspecialchars($e['title']); ?>"></div>
<div class="col"><label>برچسب</label><input type="text" name="tag" value="<?php echo htmlspecialchars($e['tag']??'سلام‌بابا'); ?>"></div>
<div class="col"><label>ترتیب</label><input type="number" name="sort_order" value="<?php echo (int)($e['sort_order']??$e['id']); ?>"></div>
<div class="col"><label>نمایش</label><select name="visible"><option value="1" <?php echo (($e['visible']??1)?'selected':''); ?>>بله</option><option value="0" <?php echo (($e['visible']??1)?'':'selected'); ?>>خیر</option></select></div>
<div class="col" style="grid-column:1/-1"><label>بولت‌ها</label><textarea name="bullets"><?php echo htmlspecialchars(implode("
",$e['bullets']??[])); ?></textarea></div>
<div class="col" style="grid-column:1/-1"><label>توضیح کوتاه</label><textarea name="desc"><?php echo htmlspecialchars($e['desc']??''); ?></textarea></div>
</div><button class="btn" type="submit" name="action" value="upsert">ذخیره تغییرات</button></form>
<?php endif; ?>
</div></body></html>