<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    exit('ACCESS DENIED');
}

$id       = (int)($_POST['id'] ?? 0);
$buy_date = trim($_POST['buy_date'] ?? '');
$buy_note = trim($_POST['buy_note'] ?? '');

if ($id < 1) exit('bad id');

// تولید متن وضعیت
$note_parts = [];
if ($buy_date !== '') {
    $note_parts[] = 'تاریخ خرید: '.$buy_date;
}
if ($buy_note !== '') {
    $note_parts[] = 'توضیحات خرید: '.$buy_note;
}
$new_status_note = implode(' | ', $note_parts);
if ($new_status_note === '') {
    $new_status_note = 'خرید انجام شد';
}

// فقط اگر سفارش مربوط به این مسئول یا ادمین باشد
if ($role === 'admin') {
    $stmt = $mysqli->prepare("UPDATE orders SET shipping_status='purchased', status_note=? WHERE id=? LIMIT 1");
    $stmt->bind_param("si", $new_status_note, $id);
} else {
    $stmt = $mysqli->prepare("UPDATE orders SET shipping_status='purchased', status_note=? WHERE id=? AND buyer_username=? LIMIT 1");
    $stmt->bind_param("sis", $new_status_note, $id, $username);
}
$stmt->execute();

// اطلاعات برای نوتیفیکیشن
$info = $mysqli->query("SELECT username, customer_name FROM orders WHERE id=".$id." LIMIT 1")->fetch_assoc();
if ($info) {
    $seller   = $mysqli->real_escape_string($info['username'] ?? '');
    $customer = $mysqli->real_escape_string($info['customer_name'] ?? '');
    if ($seller !== '') {
        $mysqli->query("
            INSERT INTO notifications (username, type, order_id, title, message, created_at)
            VALUES (
              '$seller',
              'status',
              $id,
              'کالا خرید شد',
              'خرید سفارش مشتری $customer انجام شد.',
              NOW()
            )
        ");
    }
}

header("Location: buyer_view.php?id=".$id);
exit;
