<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__.'/../includes/header.php';


$role = $_SESSION['role'] ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    exit('دسترسی غیرمجاز');
}

$u_esc = $mysqli->real_escape_string($username);

$action   = $_POST['action']   ?? '';
$order_id = (int)($_POST['order_id'] ?? 0);

if (!$order_id) exit("خطا: شناسه سفارش نامعتبر است");

$order = $mysqli->query("SELECT * FROM orders WHERE id=$order_id")->fetch_assoc();
if (!$order) exit("سفارش یافت نشد");

// فقط صاحب سفارش (buyer_username) یا ادمین
if ($role !== 'admin' && ($order['buyer_username'] ?? '') !== $username) {
    exit("دسترسی به این سفارش برای شما مجاز نیست");
}

// ---------- عملیات خرید ----------
if ($action === 'purchased') {
    $mysqli->query("UPDATE orders SET shipping_status='purchased' WHERE id=$order_id");

    $seller = $mysqli->real_escape_string($order['username'] ?? '');
    if ($seller !== '') {
        $inv = $mysqli->real_escape_string($order['invoice_no'] ?? '');
        $mysqli->query("
           INSERT INTO notifications (username,type,order_id,title,message)
           VALUES (
             '$seller',
             'status',
             {$order['id']},
             'کالا خرید شد',
             'سفارش $inv خریداری شد.',
             NOW()
           )
        ");
    }

    header("Location: index.php");
    exit;
}

// ---------- تحویل به سر باربر ----------
if ($action === 'handover') {

    $head = $mysqli->real_escape_string($_POST['head_carrier'] ?? '');

    if ($head === '') {
        exit("سر باربر انتخاب نشده است");
    }

    $mysqli->query("
        UPDATE orders SET 
        shipping_status='handover_to_head',
        head_carrier_username='$head'
        WHERE id=$order_id
    ");

    $mysqli->query("
        INSERT INTO notifications (username,type,order_id,title,message,created_at)
        VALUES (
          '$head',
          'order_assigned_head',
          $order_id,
          'سفارش جدید',
          'یک سفارش جدید به شما تحویل شد.',
          NOW()
        )
    ");

    header("Location: index.php");
    exit;
}

echo "عملیات نامعتبر";
