<?php
// admin/save.php
require __DIR__.'/config.php';
if (empty($_SESSION['auth'])) { http_response_code(403); exit('Forbidden'); }
check_csrf();

$json = file_exists($data_file) ? file_get_contents($data_file) : '{}';
$data = json_decode($json, true) ?: ['sections'=>[]];
$sections = $data['sections'] ?? [];

$action = $_POST['action'] ?? '';

function persist($path, $data): void {
  $fp = fopen($path, 'c+');
  if(!$fp) { http_response_code(500); exit('Cannot open data file'); }
  flock($fp, LOCK_EX);
  ftruncate($fp, 0);
  fwrite($fp, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
  fflush($fp);
  flock($fp, LOCK_UN);
  fclose($fp);
}

switch ($action) {
  case 'save-all':
    $data['site_title'] = $_POST['site_title'] ?? $data['site_title'] ?? '';
    persist($data_file, $data);
    break;
  case 'add':
    $new = $_POST['new'] ?? [];
    $id = preg_replace('/[^a-z0-9\-_]/','', strtolower($new['id'] ?? ''));
    if(!$id){ $id = 'sec'.(time()); }
    foreach ($sections as $s) if ($s['id'] === $id) { header('Location: index.php?err=dup'); exit; }
    $sec = [
      'id'=>$id,
      'title'=> $new['title'] ?? 'بخش جدید',
      'type'=>'card-details',
      'open'=> !empty($new['open']),
      'content_html'=> $new['content_html'] ?? '<p></p>',
    ];
    $sections[] = $sec;
    $data['sections'] = $sections;
    persist($data_file, $data);
    break;
  case 'delete':
    $id = $_POST['id'] ?? '';
    $sections = array_values(array_filter($sections, fn($s)=>$s['id'] !== $id));
    $data['sections'] = $sections;
    persist($data_file, $data);
    break;
  case 'up':
  case 'down':
    $id = $_POST['id'] ?? '';
    $idx = null;
    foreach ($sections as $i=>$s) if ($s['id']===$id){ $idx=$i; break; }
    if ($idx !== null){
      if ($action==='up' && $idx>0){ $tmp=$sections[$idx-1]; $sections[$idx-1]=$sections[$idx]; $sections[$idx]=$tmp; }
      if ($action==='down' && $idx<count($sections)-1){ $tmp=$sections[$idx+1]; $sections[$idx+1]=$sections[$idx]; $sections[$idx]=$tmp; }
      $data['sections'] = $sections;
      persist($data_file, $data);
    }
    break;
  case 'update':
    $id = $_POST['id'] ?? '';
    foreach ($sections as &$s){
      if ($s['id'] === $id){
        $s['title'] = $_POST['title'] ?? $s['title'];
        $s['open'] = !empty($_POST['open']);
        $s['content_html'] = $_POST['content_html'] ?? $s['content_html'];
      }
    }
    $data['sections'] = $sections;
    persist($data_file, $data);
    break;
  default:
    // do nothing
}

header('Location: index.php');
