<?php
header('Content-Type: text/html; charset=utf-8');
$path = __DIR__ . '/data/tips.json';
$tips = is_readable($path) ? json_decode(file_get_contents($path), true) : [];
usort($tips,function($a,$b){return ($a['sort_order']??$a['id']) <=> ($b['sort_order']??$b['id']);});
?> 
<!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>۴۰ نکته طلایی — سلام‌بابا</title>
<style>
@font-face{font-family:'IRANYekanX';src:url('https://salambaba.co/font/IRANYekanXRegular.woff2') format('woff2');font-weight:400;font-display:swap}
@font-face{font-family:'IRANYekanX';src:url('https://salambaba.co/font/IRANYekanXBold.woff2') format('woff2');font-weight:700;font-display:swap}
@font-face{font-family:'IRANSansWeb';src:url('https://salambaba.co/font/IRANSansWeb.woff2') format('woff2');font-weight:400;font-display:swap}
@font-face{font-family:'IRANSansWeb';src:url('https://salambaba.co/font/IRANSansWeb_Bold.woff2') format('woff2');font-weight:700;font-display:swap}
:root{--blue:#0ea5e9;--green:#22c55e;--yellow:#f59e0b;--red:#ef4444;--radius:14px;--pad:12px;--fs:14.2px;--fs-h:15.8px}
*{box-sizing:border-box}body{margin:0;direction:rtl;font-family:'IRANYekanX','IRANSansWeb',system-ui}
body[data-theme=light]{--bg:linear-gradient(135deg,#eef2f7,#fff);--text:#0f172a;--muted:#475569;--glass:rgba(255,255,255,.35);--border:1px solid rgba(0,0,0,.06);--shadow:0 6px 16px rgba(0,0,0,.08)}
body[data-theme=dark]{--bg:linear-gradient(135deg,#0b1020,#111827);--text:#f1f5f9;--muted:#cbd5e1;--glass:rgba(255,255,255,.08);--border:1px solid rgba(255,255,255,.16);--shadow:0 6px 18px rgba(0,0,0,.5)}
.wrap{padding:16px;background:var(--bg);color:var(--text)}
header.brand{position:sticky;top:0;z-index:10;margin:0 0 12px;backdrop-filter:blur(16px) saturate(150%);background:var(--glass);border:var(--border);border-radius:12px;padding:10px 12px;box-shadow:var(--shadow)}
.brand-row{display:flex;align-items:center;justify-content:space-between;gap:10px}
.logo{display:flex;align-items:center;gap:12px}
.logo-salambaba{display:flex;align-items:center;gap:8px;background:rgba(255,255,255,.35);backdrop-filter:blur(14px) saturate(150%);padding:6px 10px;border-radius:14px;box-shadow:0 4px 12px rgba(0,0,0,.15)}
.logo-salambaba .stripes{display:flex;gap:5px}
.logo-salambaba .stripes span{display:block;width:8px;height:34px;border-radius:10px}
.b{background:#2563eb}.g{background:#16a34a}.y{background:#f59e0b}.r{background:#ef4444}
.logo-salambaba .text{display:flex;flex-direction:column;line-height:1}
.logo-salambaba strong{font-size:.95rem;font-weight:700;color:var(--text)}
.logo-salambaba small{font-size:.7rem;color:var(--muted)}
.titlebox h1{margin:0;font-weight:700;font-size:1.05rem}
.titlebox p{margin:2px 0 0;font-size:.8rem;color:var(--muted)}
.tools{display:flex;gap:8px;flex-wrap:wrap}
.btn{padding:6px 10px;border-radius:10px;border:var(--border);background:var(--glass);cursor:pointer;font-weight:700;font-size:.85rem;color:inherit;text-decoration:none}
.hr-stripes{display:flex;height:3px;margin-top:8px;border-radius:999px;overflow:hidden;box-shadow:var(--shadow)}
.hr-stripes i{flex:1;display:block}
.hr-stripes i:nth-child(1){background:var(--blue)}
.hr-stripes i:nth-child(2){background:var(--green)}
.hr-stripes i:nth-child(3){background:var(--yellow)}
.hr-stripes i:nth-child(4){background:var(--red)}
.container{max-width:900px;margin:0 auto;display:grid;gap:12px}
.card{background:var(--glass);border:var(--border);backdrop-filter:blur(14px) saturate(160%);border-radius:var(--radius);padding:var(--pad);box-shadow:var(--shadow);font-size:var(--fs)}
.card h2{margin:0 0 4px;font-size:var(--fs-h);font-weight:700;display:flex;justify-content:space-between;gap:8px}
.tag{opacity:.75;font-weight:700;font-size:.78rem}
.bullets{margin:4px 0 0;padding:0 1.1rem 0 0;line-height:1.75}
.desc{margin:6px 0 0;opacity:.95;border-radius:10px;padding:8px 10px;border:var(--border);background:var(--glass);font-size:var(--fs)}
@media(max-width:640px){.container{gap:10px}.card{font-size:13.6px}.logo-salambaba .stripes span{height:26px;width:7px}}
@media print{header.brand,.btn{display:none}body{background:#fff}.card{box-shadow:none}}
</style></head><body data-theme="light"><div class="wrap">
<header class="brand"><div class="brand-row"><div class="logo">
<div class="logo-salambaba"><div class="stripes"><span class="b"></span><span class="g"></span><span class="y"></span><span class="r"></span></div><div class="text"><strong>سلام‌بابا</strong><small>SalamBaba</small></div></div>
<div class="titlebox"><h1>۴۰ نکته طلایی در مراکز فروش</h1><p>نسخهٔ شیشه‌ای فشرده — سوییچ روشن/تاریک — آماده چاپ</p></div>
</div><div class="tools"><a class="btn" href="#" onclick="window.print()">چاپ / PDF</a><a class="btn" href="#" id="toggleTheme">روشن / تاریک</a></div></div><div class="hr-stripes"><i></i><i></i><i></i><i></i></div></header>
<main class="container">
<?php foreach($tips as $t): if(($t['visible']??1)!=1) continue; ?>
<section class="card"><h2>نکته #<?php echo htmlspecialchars($t['id']); ?>: <?php echo htmlspecialchars($t['title']); ?><span class="tag"><?php echo htmlspecialchars($t['tag'] ?? 'سلام‌بابا'); ?></span></h2>
<?php if(!empty($t['bullets'])): ?><ul class="bullets"><?php foreach($t['bullets'] as $b): ?><li><?php echo htmlspecialchars($b); ?></li><?php endforeach; ?></ul><?php endif; ?>
<?php if(!empty($t['desc'])): ?><div class="desc"><?php echo htmlspecialchars($t['desc']); ?></div><?php endif; ?>
</section>
<?php endforeach; ?>
</main></div>
<script>const btn=document.getElementById('toggleTheme'),body=document.body;btn.addEventListener('click',e=>{e.preventDefault();const c=body.getAttribute('data-theme')||'light',n=c==='light'?'dark':'light';body.setAttribute('data-theme',n);btn.textContent=n==='light'?'روشن / تاریک':'تاریک / روشن'});</script>
</body></html>