<?php
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config.php';
$mysqli = db();
function clean($s){ return trim($s ?? ''); }

$code = clean($_POST['code'] ?? '');
$installer = clean($_POST['installer_name'] ?? '');
$install_date = clean($_POST['install_date'] ?? '');
$serial = clean($_POST['serial_number'] ?? '');
$notes = clean($_POST['notes'] ?? '');

if($code==='' || $installer==='' || $install_date==='' || $serial===''){
  echo json_encode(['success'=>false,'error'=>'فیلدهای اجباری خالی است'], JSON_UNESCAPED_UNICODE);
  exit;
}

// ensure tracking exists
$exists = 0;
$st = $mysqli->prepare("SELECT COUNT(*) FROM guarantee_requests WHERE tracking_code=?");
$st->bind_param("s", $code);
$st->execute();
$st->bind_result($exists);
$st->fetch(); $st->close();
if(!$exists){
  echo json_encode(['success'=>false,'error'=>'کد رهگیری معتبر نیست (درخواست نصب یافت نشد)'], JSON_UNESCAPED_UNICODE);
  exit;
}

// ensure not installed already
$exists2 = 0;
$st = $mysqli->prepare("SELECT COUNT(*) FROM installations WHERE tracking_code=?");
$st->bind_param("s", $code);
$st->execute();
$st->bind_result($exists2);
$st->fetch(); $st->close();
if($exists2){
  echo json_encode(['success'=>false,'error'=>'برای این کد قبلاً نصب ثبت شده است'], JSON_UNESCAPED_UNICODE);
  exit;
}

// insert installation
$sql = "INSERT INTO installations (tracking_code, installer_name, install_date, serial_number, notes) VALUES (?,?,?,?,?)";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("sssss", $code, $installer, $install_date, $serial, $notes);
$ok = $stmt->execute();
if(!$ok){
  echo json_encode(['success'=>false,'error'=>'DB insert failed: '.$stmt->error], JSON_UNESCAPED_UNICODE);
  exit;
}
$stmt->close();

// fetch request row for message (to include customer info)
$customer_name = $province = $address = $mobile = $model = $warranty = '';
$q = $mysqli->prepare("SELECT customer_name, province, address, mobile, model, warranty FROM guarantee_requests WHERE tracking_code=? LIMIT 1");
$q->bind_param("s", $code);
$q->execute();
$q->bind_result($customer_name, $province, $address, $mobile, $model, $warranty);
$q->fetch();
$q->close();

// telegram message
$lines = [];
$lines[] = "<b>نصب انجام شد ✅</b>";
$lines[] = "<b>کد رهگیری:</b> ".esc_html($code);
$lines[] = "<b>مشتری:</b> ".esc_html($customer_name);
$lines[] = "<b>استان:</b> ".esc_html($province);
$lines[] = "<b>آدرس:</b> ".esc_html($address);
$lines[] = "<b>همراه:</b> ".esc_html($mobile);
$lines[] = "<b>مدل:</b> ".esc_html($model);
if($warranty!=='') $lines[] = "<b>گارانتی:</b> ".esc_html($warranty);
$lines[] = "<b>سرویس‌کار:</b> ".esc_html($installer);
$lines[] = "<b>تاریخ نصب:</b> ".esc_html($install_date);
$lines[] = "<b>سریال:</b> ".esc_html($serial);
if($notes!=='') $lines[] = "<b>توضیحات:</b> ".esc_html($notes);
$lines[] = "<i>ارسال خودکار از salambaba.co/guaranti</i>";
$caption = implode("\n", $lines);
tg_send_message(TG_CHAT_INSTALLS, $caption);

echo json_encode(['success'=>true,'code'=>$code], JSON_UNESCAPED_UNICODE);
exit;
?>
